unit SuchForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, math,

  PatternmatchThread,
  ExtCtrls, ComCtrls, Gauges;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    CBUseAnimation: TCheckBox;
    TrackBar1: TTrackBar;
    BtnThreadedSearch: TButton;
    PCSearchMode: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Edit_Text: TEdit;
    Edit_Muster: TEdit;
    GroupBox2: TGroupBox;
    Label7: TLabel;
    Label6: TLabel;
    Label5: TLabel;
    Label4: TLabel;
    SECount: TSpinEdit;
    SEMuster: TSpinEdit;
    SEText: TSpinEdit;
    SESigma: TSpinEdit;
    GroupBox3: TGroupBox;
    Label8: TLabel;
    Edit_Filename: TEdit;
    BtnBrowse: TButton;
    Edit_Muster_TextDatei: TEdit;
    BtnStop: TButton;
    BtnAnhalten: TButton;
    GrpBox0: TGroupBox;
    PaintBox0: TPaintBox;
    GrpBox1: TGroupBox;
    PaintBox1: TPaintBox;
    GrpBox2: TGroupBox;
    PaintBox2: TPaintBox;
    GrpBox3: TGroupBox;
    PaintBox3: TPaintBox;
    GrpBoxAlgChoose: TGroupBox;
    cbNaiv: TCheckBox;
    cbKMP_F: TCheckBox;
    cbKMP_Next: TCheckBox;
    cbBM_Strong: TCheckBox;
    Gauge0: TGauge;
    Gauge1: TGauge;
    Gauge2: TGauge;
    Gauge3: TGauge;
    LblPatternFound0: TLabel;
    LblCount0: TLabel;
    LblPatternFound1: TLabel;
    LblPatternFound2: TLabel;
    LblPatternFound3: TLabel;
    LblCount1: TLabel;
    LblCount2: TLabel;
    LblCount3: TLabel;
    GrpBox4: TGroupBox;
    PaintBox4: TPaintBox;
    Gauge4: TGauge;
    LblPatternFound4: TLabel;
    LblCount4: TLabel;
    cbBM_Weak: TCheckBox;
    Label1: TLabel;
    CBPreSelect: TComboBox;
    cbHorspool: TCheckBox;
    GrpBox5: TGroupBox;
    PaintBox5: TPaintBox;
    Gauge5: TGauge;
    LblPatternFound5: TLabel;
    LblCount5: TLabel;
    procedure BtnBrowseClick(Sender: TObject);
    procedure ReFreshPaintbox(Mode: Integer; aBitmap: TBitmap);
    procedure BtnThreadedSearchClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);

    procedure FreeAndNilThread(Sender: TObject);

    procedure PrepareOutput;

    procedure DrawText(Mode, StartPos, StartG, EndG, StartR, EndR, Gelb: Integer; aShift: Integer = 0);
    procedure DrawPattern(Mode, StartPos, StartG, EndG, StartR, EndR, Gelb: Integer; aShift: Integer = 0);
    procedure BtnStopClick(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure BtnAnhaltenClick(Sender: TObject);
    procedure CBUseAnimationClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure CBPreSelectChange(Sender: TObject);

  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    CBAlgorithms : Array of TCheckBox;

  end;

Const
  ALG_COUNT = 6;
  PreSelectTexts: Array [0..3] of String  = (
         'und abraham sprach abrakadabra',
         '---------------------------------X',
         'abcabcabcabcXabcabcabcabcacab',
         '--------------------aababababababababababa--------------------cababababababababababa'
         );
  PreSelectPatterns: Array [0..3] of String  = (
          'abrakadabra',
          '------------X',
          'abcabcabcabcacab',
          'cababababababababababa'
          );
  PreCheckedAlgorithms: Array [0..3,0..ALG_COUNT-1] of Boolean = (
          (True, True, True, True, True, False),
          (True, True, True, False, False, False),
          (False, True, True, False, False, False),
          (False, False, False, True, True, False)
           );


var
  Form1: TForm1;

  PatternmatchAnimators: Array[0..ALG_COUNT-1] of TPatternmatchAnimator;
  ThreadIsRunning: Array[0..ALG_COUNT-1] of Boolean;
  RunningThreads: Integer;
  OffScreenbmps: Array[0..ALG_COUNT-1] of TBitmap;
  Textbmp: TBitmap;
  aText: String;
  aPattern: String;

   st,et: Int64;




implementation

{$R *.dfm}

procedure TForm1.BtnBrowseClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
    Edit_Filename.TExt := OpenDialog1.FileName;
end;


procedure TForm1.ReFreshPaintbox(Mode: Integer; aBitmap: TBitmap);
begin
  case Mode of
      0: Paintbox0.Canvas.Draw(0,0,aBitmap);
      1: Paintbox1.Canvas.Draw(0,0,aBitmap);
      2: Paintbox2.Canvas.Draw(0,0,aBitmap);
      3: Paintbox3.Canvas.Draw(0,0,aBitmap);
      4: Paintbox4.Canvas.Draw(0,0,aBitmap);
      5: Paintbox5.Canvas.Draw(0,0,aBitmap);

  end;
end;

procedure TForm1.FreeAndNilThread(Sender: TObject);
var athread: TPatternmatchAnimator;
  s: Integer;
  t: int64;
begin
  ThousandSeparator := '.';
  et := GetTickCount;
  t := et-st;
  if Sender is TPatternmatchAnimator then
  begin
    aThread := Sender as TPatternmatchAnimator;
    ThreadIsRunning[aThread.Mode] := False;
    TGauge(FindComponent('Gauge'+IntToStr(aThread.Mode))).Progress := 100;
    TLabel(FindComponent('LblCount' + IntToStr(aThread.Mode))).Caption :=
    Format('bentigte Vergleiche: %d', [aThread.Count]);
      //'bentigte Vergleiche: ' +
     // IntToStr(aThread.Count);
    TLabel(FindComponent('LblPatternFound' + IntToStr(aThread.Mode))).Caption :='Muster gefunden an Position: ' + IntToStr(aThread.PatternFoundAt);

    TLabel(FindComponent('LblFak' + IntToStr(aThread.Mode))).Caption := FloatToStrF (aThread.Count / (Length(aThread.Text) - Length(aThread.Pattern) + 1),
    ffFixed, 10, 10 );


    dec(RunningThreads);
    if RunningThreads = 0 then
    begin
      BtnThreadedSearch.Enabled := True;
      BtnStop.Enabled := False;
      BtnAnhalten.Enabled := False;
      Form1.FocusControl(BtnThreadedSearch);
    end;

    if aThread.Mode = 0 then
    begin
        s := 1;
        repeat
          inc(s);
        until (s > 30000) or (Round( (Length(aThread.Text) - Length(aThread.Pattern) + 1) *    (power(1/s, Length(aThread.Pattern) + 1) - 1) / (1/s - 1)) <= aThread.Count);
    end;
  end;
end;

procedure TForm1.PrepareOutput;
var t: Integer;
begin
  // Top der ersten visible-Box
  t := 224;
  GrpBox0.Visible := cbNaiv.Checked;
  if cbNaiv.Checked then
  begin
    GrpBox0.Top := t;
    inc(t, GrpBox0.Height + 2);
  end;

  GrpBox1.Visible := cbKMP_F.Checked;
  if cbKMP_F.Checked then
  begin
    GrpBox1.Top := t;
    inc(t, GrpBox1.Height + 2);
  end;

  GrpBox2.Visible := cbKMP_Next.Checked;
  if cbKMP_Next.Checked then
  begin
    GrpBox2.Top := t;
    inc(t, GrpBox2.Height + 2);
  end;

  GrpBox3.Visible := cbBM_Strong.Checked;
  if cbBM_Strong.Checked then
  begin
    GrpBox3.Top := t;
    inc(t, GrpBox3.Height + 2);
  end;

  GrpBox4.Visible := cbBM_Weak.Checked;
  if cbBM_Weak.Checked then
  begin
    GrpBox4.Top := t;
    inc(t, GrpBox4.Height + 2);
  end;

  GrpBox5.Visible := cbHorspool.Checked;
  if cbHorspool.Checked then
  begin
    GrpBox5.Top := t;
    inc(t, GrpBox5.Height + 2);
  end;


end;


procedure TForm1.BtnThreadedSearchClick(Sender: TObject);
var
  tmplist: TStringlist;
  i: Integer;
  tmpstr: String;

begin

  PrepareOutput;
  RunningThreads := 0;


  case PCSearchMode.ActivePageIndex of
    0: begin
      aText    := Edit_Text.Text;
      aPattern := Edit_Muster.Text;
    end;
    1: begin
      aText    := GenerateRandomString(SEText.value, SESigma.Value);
      aPattern := GenerateRandomString(SEMuster.value, SESigma.Value);
    end;
    2: begin
      tmplist := TStringlist.Create;
      tmplist.LoadFromFile(Edit_Filename.Text);
      tmpstr := '';
      for i := 0 to tmplist.Count - 1 do
        tmpstr := tmpstr + ' ' + tmplist[i];
      aText := tmpstr;
      tmplist.Free;
      aPattern := AnsiLowerCase(Edit_Muster_TextDatei.Text);
    end;
  end;

  BtnThreadedSearch.Enabled := False;
  BtnAnhalten.Enabled := True;
  BtnAnhalten.Caption := 'Anhalten';
  BtnStop.Enabled := True;

  for i := 0 to ALG_COUNT-1 do
    if CBAlgorithms[i].Checked then
    begin
      PatternmatchAnimators[i] := TPatternmatchAnimator.Create(True);
      PatternmatchAnimators[i].FreeOnTerminate := True;
      PatternmatchAnimators[i].Priority := tpidle;
      PatternmatchAnimators[i].Text    := aText;
      PatternmatchAnimators[i].Pattern := aPattern;
      PatternmatchAnimators[i].UseAnimation := CBUseAnimation.Checked;
      PatternmatchAnimators[i].DelayTime := Trackbar1.Max - Trackbar1.Position;
      PatternmatchAnimators[i].RepaintPatternProc := DrawPattern;
      PatternmatchAnimators[i].RepaintTextProc := DrawText;
      PatternmatchAnimators[i].OnTerminate := FreeAndNilThread;
      PatternmatchAnimators[i].Mode := i;
      PatternmatchAnimators[i].MachePause := False;
      ThreadIsRunning[i] := True;
      inc(RunningThreads);
      DrawText(i, 0, -1, -1, -1, -1, -1);
      DrawPattern(i, 0, -1, -1, -1, -1, -1);
    end;

  if length(aText) >= 100000000 then
    showmessage('Bereit...');


  st := GetTickCount;
  for i := 0 to ALG_COUNT-1 do
    if CBAlgorithms[i].Checked then
      PatternmatchAnimators[i].Resume;
end;

procedure TForm1.FormCreate(Sender: TObject);
var i: Integer;
begin
  Textbmp := TBitmap.Create;
  TextBmp.Height := ANIMATE_CHARWIDTH;
  TextBmp.Width := Paintbox0.Width-16;
  Textbmp.Canvas.Font.Size := ANIMATE_FONTZIZE;
//  Textbmp.Canvas.Font.Style := [fsBold];

  for i := 0 to High(ThreadIsRunning) do
    ThreadIsRunning[i] := False;

  for i := 0 to High(OffScreenbmps) do
  begin
    OffScreenbmps[i] := TBitmap.Create;
    OffScreenbmps[i].Canvas.Font.Size := ANIMATE_FONTZIZE;
    OffScreenbmps[i].Canvas.Brush.Color := ClWindow;
    OffScreenbmps[i].Width := Paintbox0.Width;
    OffScreenbmps[i].Height := Paintbox0.Height;
  end;

  Setlength(CBAlgorithms, ALG_COUNT);
  CBAlgorithms[0] := cbnaiv;
  CBAlgorithms[1] := cbKMP_F;
  CBAlgorithms[2] := cbKMP_Next;
  CBAlgorithms[3] := cbBM_Strong;
  CBAlgorithms[4] := cbBM_Weak;
  CBAlgorithms[5] := cbHorspool;


end;

procedure TForm1.FormDestroy(Sender: TObject);
var i: Integer;
begin
  for i := 0 to High(OffScreenbmps) do
    OffScreenbmps[i].Free;
end;

// Zeichnet den text neu.
// Inklusive eventueller grner oder roten Bereiche, sowie einem vorgegebenen gelben Char
//
procedure TForm1.DrawText(Mode, StartPos, StartG, EndG, StartR, EndR, Gelb: Integer; aShift: Integer = 0);
var i, paintx: Integer;
  tmpcharwidth: Integer;
  tmpcharheight: Integer;

begin
  paintx := (ANIMATE_CHARWIDTH Div 2) - aShift;
  Textbmp.Canvas.Brush.Style := bsSolid;
  TextBmp.Canvas.Brush.Color := clWindow;
  TextBmp.Canvas.FillRect(Rect(0,0,Textbmp.Width, Textbmp.Height));

  if Startpos<1 then Startpos := 1;

  i := Startpos;
  while (i <= Length(aText)) and ((i-Startpos) * ANIMATE_CHARWIDTH <= Textbmp.Width) do
  begin

    Textbmp.Canvas.Brush.Color := clWindow;

    if (i >= StartG) AND (i <= EndG) then
      Textbmp.Canvas.Brush.Color := clGreen;

    if (i >= StartR) AND (i <= EndR) then
      Textbmp.Canvas.Brush.Color := clRed;

    if i = Gelb then
      Textbmp.Canvas.Brush.Color := clYellow;

    tmpcharwidth := Textbmp.Canvas.TextWidth(aText[i]);
    tmpcharheight := Textbmp.Canvas.TextHeight(aText[i]);

    Textbmp.Canvas.Rectangle(PaintX - (ANIMATE_CHARWIDTH Div 2),
                                   0,
                                   PaintX + (ANIMATE_CHARWIDTH Div 2),
                                   TextBmp.Height
                                  );
    Textbmp.Canvas.TextOut(PaintX - (tmpcharwidth Div 2) ,
                          (TextBmp.Height Div 2) - (tmpcharheight Div 2),
                          aText[i]);

    Textbmp.Canvas.Brush.Style := bsClear;
    Textbmp.Canvas.Rectangle(PaintX - (ANIMATE_CHARWIDTH Div 2),
                             0,
                             PaintX + (ANIMATE_CHARWIDTH Div 2),
                             TextBmp.Height
                            );
    inc(Paintx, ANIMATE_CHARWIDTH);
    inc(i);
  end;

  OffScreenbmps[Mode].Canvas.Draw(8,8, Textbmp);

  case Mode of
      0: begin
          Paintbox0.Canvas.Draw(0,0,OffScreenbmps[Mode]);
          Gauge0.Progress := Round(StartPos / Length(aText)  * 100);
      end;
      1: begin
          Paintbox1.Canvas.Draw(0,0,OffScreenbmps[Mode]);
          Gauge1.Progress := Round(StartPos / Length(aText)  * 100);
      end;
      2: begin
          Paintbox2.Canvas.Draw(0,0,OffScreenbmps[Mode]);
          Gauge2.Progress := Round(StartPos / Length(aText)  * 100);
      end;
      3: begin
          Paintbox3.Canvas.Draw(0,0,OffScreenbmps[Mode]);
          Gauge3.Progress := Round(StartPos / Length(aText)  * 100);
      end;
      4: begin
          Paintbox4.Canvas.Draw(0,0,OffScreenbmps[Mode]);
          Gauge4.Progress := Round(StartPos / Length(aText)  * 100);
      end;
      5: begin
          Paintbox5.Canvas.Draw(0,0,OffScreenbmps[Mode]);
          Gauge5.Progress := Round(StartPos / Length(aText)  * 100);
      end;

  end;

  //if aShift= 0 then Application.ProcessMessages;
end;




procedure TForm1.DrawPattern(Mode, StartPos, StartG, EndG, StartR, EndR, Gelb: Integer; aShift: Integer = 0);
var i, paintx: Integer;
  tmpcharwidth: Integer;
  tmpcharheight: Integer;

begin
  paintx := (ANIMATE_CHARWIDTH Div 2);
  Textbmp.Canvas.Brush.Style := bsSolid;
  TextBmp.Canvas.Brush.Color := clWindow;
  TextBmp.Canvas.FillRect(Rect(0,0,Textbmp.Width, Textbmp.Height));
//  TextBmp.Canvas.FillRect(TextBmp.Canvas.ClipRect);

  i := 1;
  while (i <= Length(aPattern)) {and ((i-Startpos) * fCharWidth <= Textbmp.Width)} do
  begin
    Textbmp.Canvas.Brush.Color := clWindow;

    if (i  >= StartG) AND (i  <= EndG) then
      Textbmp.Canvas.Brush.Color := clGreen;

    if (i >= StartR) AND (i <= EndR) then
      Textbmp.Canvas.Brush.Color := clRed;

    if i = Gelb then
      Textbmp.Canvas.Brush.Color := clYellow;

   { if i + StartPos -1 = VergleichsPos then
    begin
      if aText[VergleichsPos] = aPattern[VergleichsPos - StartPos + 1] then
        Textbmp.Canvas.Brush.Color := clGreen
      else
        Textbmp.Canvas.Brush.Color := clRed;
    end;  }

    tmpcharwidth := Textbmp.Canvas.TextWidth(aPattern[i]);
    tmpcharheight := Textbmp.Canvas.TextHeight(aPattern[i]);

    Textbmp.Canvas.Rectangle(PaintX - (ANIMATE_CHARWIDTH Div 2),
                                   0,
                                   PaintX + (ANIMATE_CHARWIDTH Div 2),
                                   TextBmp.Height
                                  );

    Textbmp.Canvas.TextOut(PaintX - (tmpcharwidth Div 2) ,
                          (TextBmp.Height Div 2) - (tmpcharheight Div 2),
                          aPattern[i]);

    Textbmp.Canvas.Brush.Style := bsClear;
    Textbmp.Canvas.Rectangle(PaintX - (ANIMATE_CHARWIDTH Div 2),
                             0,
                             PaintX + (ANIMATE_CHARWIDTH Div 2),
                             TextBmp.Height
                            );
    inc(Paintx, ANIMATE_CHARWIDTH);
    inc(i);
  end;

  OffScreenbmps[Mode].Canvas.Draw(8,8 + Textbmp.Height + 8, Textbmp);
  case Mode of
      0: Paintbox0.Canvas.Draw(0,0,OffScreenbmps[Mode]);
      1: Paintbox1.Canvas.Draw(0,0,OffScreenbmps[Mode]);
      2: Paintbox2.Canvas.Draw(0,0,OffScreenbmps[Mode]);
      3: Paintbox3.Canvas.Draw(0,0,OffScreenbmps[Mode]);
      4: Paintbox4.Canvas.Draw(0,0,OffScreenbmps[Mode]);
      5: Paintbox5.Canvas.Draw(0,0,OffScreenbmps[Mode]);

  end;
end;



procedure TForm1.BtnStopClick(Sender: TObject);
var i: Integer;
begin
    BtnAnhalten.Enabled := False;
    for i := 0 to High(ThreadIsRunning) do
    if ThreadIsRunning[i] then
    begin
      PatternmatchAnimators[i].UseAnimation := False;
      PatternmatchAnimators[i].Terminate;
    end;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
var i: Integer;
begin
  for i := 0 to High(ThreadIsRunning) do
    if ThreadIsRunning[i] then
    begin
      PatternmatchAnimators[i].DelayTime := TrackBar1.Max - Trackbar1.Position;
    end;
end;

procedure TForm1.BtnAnhaltenClick(Sender: TObject);
var i: Integer;
begin
    if BtnAnhalten.Caption = 'Anhalten' then
      BtnAnhalten.Caption := 'Weiter'
    else
      BtnAnhalten.Caption := 'Anhalten';

    for i := 0 to High(ThreadIsRunning) do
    if ThreadIsRunning[i] then
    begin
      PatternmatchAnimators[i].MachePause := NOT PatternmatchAnimators[i].MachePause;
    end;
end;


procedure TForm1.CBUseAnimationClick(Sender: TObject);
var i: Integer;
begin
    for i := 0 to High(ThreadIsRunning) do
    if ThreadIsRunning[i] then
    begin
      PatternmatchAnimators[i].UseAnimation := CBUseAnimation.Checked;
    end;

end;

procedure TForm1.FormResize(Sender: TObject);
var i: Integer;
begin
  TextBmp.Width := Paintbox0.Width-16;
  for i := 0 to High(OffScreenbmps) do
    OffScreenbmps[i].Width := Paintbox0.Width;

end;

procedure TForm1.CBPreSelectChange(Sender: TObject);
var i: Integer;
begin
  Edit_Text.Text := PreSelectTexts[CBPreSelect.ItemIndex];
  Edit_Muster.Text := PreSelectPatterns[CBPreSelect.ItemIndex];
  for i := 0 to ALG_COUNT-1 do
    CBAlgorithms[i].Checked := PreCheckedAlgorithms[CBPreSelect.ItemIndex][i];


end;

end.
